<?php

class PaymentController extends Controller {

    private $paymentModel;
    private $invoiceModel;

    public function __construct() {
        $this->paymentModel = $this->model('Payment');
        $this->invoiceModel = $this->model('Invoice'); // assuming you already have Invoice model
        
    }

    public function index($invoice_id = null) {
        $filters = [
            'invoice_id' => $_GET['invoice_id'] ?? $invoice_id
        ];
        if ($filters['invoice_id']) {
            $payments = $this->paymentModel->getPaymentsByInvoiceId($filters['invoice_id']);
        } else {
            $payments = [];
        }

        include __DIR__ . '/../views/payments/index.php';
    }

    public function add() {
        $error = '';
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $data = [
                'invoice_id'   => $_POST['invoice_id'],
                'amount'       => $_POST['amount'],
                'payment_date' => $_POST['payment_date'],
                'method'       => $_POST['method'],
                'reference'    => $_POST['reference']
            ];

            if ($this->paymentModel->addPayment($data)) {
                $_SESSION['success'] = "Payment added successfully.";
                header("Location: " . BASE_URL . "/payment/index/" . $data['invoice_id']);
                exit;
            } else {
                $error = "Failed to add payment.";
            }
        }

        $invoices = $this->invoiceModel->getAll(); // for dropdown
        include __DIR__ . '/../views/payments/add.php';
    }

    public function edit($id) {
        $error = '';
        $payment = $this->paymentModel->getPaymentById($id);

        if (!$payment) {
            $_SESSION['error'] = "Payment not found.";
            header("Location: " . BASE_URL . "/payment");
            exit;
        }

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $data = [
                'invoice_id'   => $_POST['invoice_id'],
                'amount'       => $_POST['amount'],
                'payment_date' => $_POST['payment_date'],
                'method'       => $_POST['method'],
                'reference'    => $_POST['reference']
            ];

            if ($this->paymentModel->updatePayment($id, $data)) {
                $_SESSION['success'] = "Payment updated successfully.";
                header("Location: " . BASE_URL . "/payment/index/" . $data['invoice_id']);
                exit;
            } else {
                $error = "Failed to update payment.";
            }
        }

        $invoices = $this->invoiceModel->getAll();
        include __DIR__ . '/../views/payments/edit.php';
    }

    public function delete($id) {
        $payment = $this->paymentModel->getPaymentById($id);
        if ($payment && $this->paymentModel->deletePayment($id)) {
            $_SESSION['success'] = "Payment deleted successfully.";
        } else {
            $_SESSION['error'] = "Failed to delete payment.";
        }

        header("Location: " . BASE_URL . "/payment/index/" . ($payment['invoice_id'] ?? ''));
        exit;
    }
}
