<?php

class Customer extends Model {
    // public function addCustomer($data) {
    //     $stmt = $this->db->prepare("
    //         INSERT INTO customers (
    //             user_id, name, email, phone, company, 
    //             address_1, address_2, city, country, postcode, unit_number, created_at
    //         )
    //         VALUES (
    //             :user_id, :name, :email, :phone, :company,
    //             :address_1, :address_2, :city, :country, :postcode, :unit_number, NOW()
    //         )
    //     ");
    //     return $stmt->execute([
    //         'user_id' => $data['user_id'],
    //         'name' => $data['name'],
    //         'email' => $data['email'],
    //         'phone' => $data['phone'] ?? null,
    //         'company' => $data['company'] ?? null,
    //         'address_1' => $data['address_1'] ?? null,
    //         'address_2' => $data['address_2'] ?? null,
    //         'city' => $data['city'] ?? null,
    //         'country' => $data['country'] ?? null,
    //         'postcode' => $data['postcode'] ?? null,
    //         'unit_number' => $data['unit_number'] ?? null,
    //     ]);
    // }

    public function getCustomerById($id) {
        $stmt = $this->db->prepare("SELECT * FROM customers WHERE id = ?");
        $stmt->execute([$id]);
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    public function getCustomersPaginated($userId, $role, $limit, $offset) {
        if (strtolower($role) === 'admin') {
            $stmt = $this->db->prepare("SELECT * FROM customers ORDER BY created_at DESC LIMIT :limit OFFSET :offset");
        } else {
            $stmt = $this->db->prepare("SELECT * FROM customers WHERE user_id = :user_id ORDER BY created_at DESC LIMIT :limit OFFSET :offset");
            $stmt->bindValue(':user_id', $userId, PDO::PARAM_INT);
        }
        $stmt->bindValue(':limit', (int)$limit, PDO::PARAM_INT);
        $stmt->bindValue(':offset', (int)$offset, PDO::PARAM_INT);
        $stmt->execute();

        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function countCustomers($userId, $role) {
        if (strtolower($role) === 'admin') {
            $stmt = $this->db->query("SELECT COUNT(*) FROM customers");
        } else {
            $stmt = $this->db->prepare("SELECT COUNT(*) FROM customers WHERE user_id = ?");
            $stmt->execute([$userId]);
        }
        return $stmt->fetchColumn();
    }

    public function updateCustomer($id, $data) {
        $stmt = $this->db->prepare("
            UPDATE customers SET 
                name = ?, email = ?, phone = ?, company = ?,
                address_1 = ?, address_2 = ?, city = ?, country = ?, postcode = ?, unit_number = ?
            WHERE id = ?
        ");
        return $stmt->execute([
            $data['name'],
            $data['email'],
            $data['phone'] ?? null,
            $data['company'] ?? null,
            $data['address_1'] ?? null,
            $data['address_2'] ?? null,
            $data['city'] ?? null,
            $data['country'] ?? null,
            $data['postcode'] ?? null,
            $data['unit_number'] ?? null,
            $id
        ]);
    }

    public function deleteCustomer($id) {
        $stmt = $this->db->prepare("DELETE FROM customers WHERE id = ?");
        return $stmt->execute([$id]);
    }
    
    public function getAllCustomers()
{
    $stmt = $this->db->query("SELECT * FROM customers ORDER BY name");
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

public function addCustomer($data)
{
    $stmt = $this->db->prepare("
        INSERT INTO customers (user_id,name, email, phone, company, address_1, address_2, city, country, postcode, unit_number)
        VALUES (:user_id, :name, :email, :phone, :company, :address_1, :address_2, :city, :country, :postcode, :unit_number)
    ");
    $success = $stmt->execute([
        ':user_id' => $data['user_id'],
        ':name' => $data['name'],
        ':email' => $data['email'],
        ':phone' => $data['phone'],
        ':company' => $data['company'],
        ':address_1' => $data['address_1'],
        ':address_2' => $data['address_2'],
        ':city' => $data['city'],
        ':country' => $data['country'],
        ':postcode' => $data['postcode'],
        ':unit_number' => $data['unit_number']
    ]);
    return $success ? $this->db->lastInsertId() : false;
}

}
