<div class="container mt-4">
   <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-3 gap-2">
    <h3 class="mb-0">
        <i class="bi bi-person-lines-fill"></i> Contacts
    </h3>

    <?php if ((isset($role) && $role === 'admin') || $role === 'agent'): ?>
        <div class="d-flex flex-wrap gap-2">
            <a href="<?= BASE_URL ?>/contacts/add" class="btn btn-success flex-fill flex-sm-grow-0">
                <i class="bi bi-person-plus"></i> Add Contact
            </a>
            <?php if ($_SESSION['user_role'] === 'admin'): ?>
            <a href="<?= BASE_URL ?>/contacts/assign" class="btn btn-success flex-fill flex-sm-grow-0">
                <i class="bi bi-person-check"></i> Assign Contact
            </a>

            <a href="<?= BASE_URL ?>/contacts/manageAssignments" class="btn btn-success flex-fill flex-sm-grow-0">
                <i class="bi bi-people"></i> Manage Assigned Contact
            </a>
            <?php endif; ?>
            <a href="<?= BASE_URL ?>/dashboard/<?= $role ?? 'agent' ?>" class="btn btn-secondary flex-fill flex-sm-grow-0">
                <i class="bi bi-arrow-left"></i> Back to Dashboard
            </a>
        </div>
    <?php endif; ?>
</div>

    <?php if (!empty($_SESSION['error'])): ?>
    <div class="alert alert-danger"><?= $_SESSION['error']; unset($_SESSION['error']); ?></div>
<?php endif; ?>

<?php if (!empty($_SESSION['success'])): ?>
    <div class="alert alert-success"><?= $_SESSION['success']; unset($_SESSION['success']); ?></div>
<?php endif; ?>


    <?php if (!empty($contacts)): ?>
        <div class="table-responsive">
            <table class="table table-hover table-bordered align-middle">
                <thead class="table-light">
                    <tr>
                        <th><i class="bi bi-person"></i> Name</th>
                        <th><i class="bi bi-envelope"></i> Email</th>
                        <th><i class="bi bi-telephone"></i> Phone</th>
                        <th><i class="bi bi-building"></i> Company</th>
                        <?php if (isset($role) && $role === 'admin'): ?>
                            <th><i class="bi bi-person-badge"></i> Owner</th>
                        <?php endif; ?>
                        <th><i class="bi bi-gear"></i> Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($contacts as $contact): ?>
                    <?php
                    $pending = $contact['task_pending'] ?? 0;
                    $completed = $contact['task_completed'] ?? 0;
                    ?>
                        <tr>
                            <td><?= htmlspecialchars($contact['name']) ?></td>
                            <td><?= htmlspecialchars($contact['email']) ?></td>
                            <td><?= htmlspecialchars($contact['phone']) ?></td>
                            <td><?= htmlspecialchars($contact['company']) ?></td>
                            <?php if (isset($role) && $role === 'admin'): ?>
                                <td><?= htmlspecialchars($contact['owner_name'] ?? 'You') ?></td>
                            <?php endif; ?>
                            <td>
                                <a href="<?= BASE_URL ?>/contacts/notes/<?= $contact['id'] ?>" class="btn btn-sm btn-outline-info" title="View Notes">
                                    <i class="bi bi-eye"></i>
                                </a>
                                
                                <a href="<?= BASE_URL ?>/contacts/edit/<?= $contact['id'] ?>" class="btn btn-sm btn-outline-warning" title="Edit Contact">
                                    <i class="bi bi-pencil-square"></i>
                                </a>

                                
                                <a href="<?= BASE_URL ?>/InteractionController/contact/<?= $contact['id'] ?>" class="btn btn-sm btn-outline-success" title="View Interactions">
                                    <i class="bi bi-chat-dots"></i>
                                </a>
                                
                                 <!-- View Tasks -->
                                <a href="<?= BASE_URL ?>/TaskController/contact/<?= $contact['id'] ?>" class="btn btn-sm btn-outline-success position-relative" title="View Tasks">
                                    <i class="bi bi-list-check"></i>
                                    <?php if ($pending > 0): ?>
                                        <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger">
                                            <?= $pending ?>
                                        </span>
                                    <?php elseif ($completed > 0): ?>
                                        <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-success">
                                            ✔
                                        </span>
                                    <?php endif; ?>
                                </a>


                                <a href="<?= BASE_URL ?>/contacts/delete/<?= $contact['id'] ?>" class="btn btn-sm btn-outline-danger" onclick="return confirm('Are you sure you want to delete this contact?')">
                                    <i class="bi bi-trash"></i>
                                </a>
                                
                                
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php else: ?>
        <div class="alert alert-info text-center">📭 No contacts found.</div>
    <?php endif; ?>

    <!-- 🔁 Pagination -->
    <?php if (isset($totalPages) && $totalPages > 1): ?>
        <nav>
            <ul class="pagination justify-content-center mt-4">
                <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                    <li class="page-item <?= $i == $currentPage ? 'active' : '' ?>">
                        <a class="page-link" href="?page=<?= $i ?>">
                            <?= $i ?>
                        </a>
                    </li>
                <?php endfor; ?>
            </ul>
        </nav>
    <?php endif; ?>

    <div class="mt-3">
        
    </div>
</div>
