<!-- Notes Section -->
<div class="card mt-4">
    <div class="card-header bg-success text-white d-flex justify-content-between align-items-center">
        <strong><i class="bi bi-stickies"></i> Notes</strong>
        <button class="btn btn-light btn-sm" data-bs-toggle="collapse" data-bs-target="#noteForm">➕</button>
    </div>

    <div class="collapse" id="noteForm">
        <div class="card-body">
            <form action="<?= BASE_URL ?>/contacts/notes/<?= $contact['id'] ?>" method="POST">
                <input type="hidden" name="contact_id" value="<?= $contact['id'] ?>">
                <textarea name="note_content" class="form-control mb-2" rows="3" required placeholder="Enter your note here..."></textarea>
                <button type="submit" class="btn btn-primary">📝 Add Note</button>
            </form>
        </div>
    </div>

    <div class="card-body">
        <?php if (!empty($notes)): ?>
            <?php foreach ($notes as $note): ?>
                <div class="border p-3 mb-2 rounded shadow-sm bg-light">
                    <small class="text-muted">
                        Created: <?= date('Y-m-d', strtotime($note['created_at'])) ?> |
                        Time: <?= date('H:i:s', strtotime($note['created_at'])) ?> |
                        By: <em><?= htmlspecialchars($note['author_name']) ?></em>
                    </small>
                    <p class="mb-0 mt-2"><?= nl2br(htmlspecialchars($note['content'])) ?></p>
            
                    <?php if ($_SESSION['user_id'] == $note['user_id']): ?>
                        <div class="mt-2 d-flex gap-2">
                            <a href="<?= BASE_URL ?>/contacts/editNote/<?= $note['id'] ?>" class="btn btn-sm btn-outline-primary">
                                <i class="bi bi-pencil-square"></i> Edit
                            </a>
                            <a href="<?= BASE_URL ?>/contacts/deleteNote/<?= $note['id'] ?>" class="btn btn-sm btn-outline-danger" onclick="return confirm('Delete this note?')">
                                <i class="bi bi-trash"></i> Delete
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endforeach; ?>

        <?php else: ?>
            <div class="alert alert-info">No notes yet for this contact.</div>
        <?php endif; ?>
    </div>
</div>

<div class="mt-3">
    <a href="<?= BASE_URL ?>/contacts/" class="btn btn-secondary">
        <i class="bi bi-arrow-left"></i> Back to Contacts
    </a>
</div>
