<div class="container mt-4">
    <div class="card shadow-sm">
        <div class="card-header bg-warning text-dark">
            <h4 class="mb-0">✏️ Edit Customer</h4>
        </div>
        <div class="card-body">
            <?php if (!empty($error)): ?>
                <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
            <?php endif; ?>

            <form method="post" action="">
                <div class="mb-3">
                    <label class="form-label">Name</label>
                    <input type="text" name="name" value="<?= htmlspecialchars($customer['name']) ?>" class="form-control" required>
                </div>

                <div class="mb-3">
                    <label class="form-label">Email</label>
                    <input type="email" name="email" value="<?= htmlspecialchars($customer['email']) ?>" class="form-control" required>
                </div>

                <div class="mb-3">
                    <label class="form-label">Phone</label>
                    <input type="text" name="phone" value="<?= htmlspecialchars($customer['phone']) ?>" class="form-control">
                </div>

                <div class="mb-3">
                    <label class="form-label">Company</label>
                    <input type="text" name="company" value="<?= htmlspecialchars($customer['company']) ?>" class="form-control">
                </div>
                
                <div class="mb-3">
                    <label class="form-label">Address 1</label>
                    <input type="text" name="address_1" value="<?= htmlspecialchars($customer['address_1']) ?>" class="form-control">
                </div>
            
                <div class="mb-3">
                    <label class="form-label">Address 2</label>
                    <input type="text" name="address_2" value="<?= htmlspecialchars($customer['address_2']) ?>" class="form-control">
                </div>
            
                <div class="mb-3">
                    <label class="form-label">Town/City</label>
                    <input type="text" name="city" value="<?= htmlspecialchars($customer['city']) ?>" class="form-control">
                </div>
            
                <div class="mb-3">
                    <label class="form-label">Country</label>
                    <input type="text" name="country" value="<?= htmlspecialchars($customer['country']) ?>" class="form-control">
                </div>
            
                <div class="mb-3">
                    <label class="form-label">Postcode</label>
                    <input type="text" name="postcode" value="<?= htmlspecialchars($customer['postcode']) ?>" class="form-control">
                </div>
            
                <div class="mb-3">
                    <label class="form-label">Unit Number</label>
                    <input type="text" name="unit_number" value="<?= htmlspecialchars($customer['unit_number']) ?>" class="form-control">
                </div>

                <button type="submit" class="btn btn-primary">Update Customer</button>
                <a href="<?= BASE_URL ?>/customer" class="btn btn-secondary">Cancel</a>
            </form>
        </div>
    </div>
</div>
