<div class="text-center mb-4">
    <h1 class="display-5 fw-bold">Welcome, <?= htmlspecialchars($_SESSION['user_name']) ?> 👋</h1>
    <p class="text-muted">You're logged in as <strong><?= ucfirst($_SESSION['user_role']) ?></strong>.</p>
</div>

<!-- 🔔 Task Summary Widgets -->
<div class="row mb-4">
    <div class="col-md-4">
        <a href="<?= BASE_URL ?>/TaskController/reminders/pending" class="text-decoration-none">
            <div class="card border-start border-4 border-danger shadow-sm h-100">
                <div class="card-body">
                    <h6 class="card-title text-muted"><i class="bi bi-bell-fill"></i> Pending Tasks</h6>
                    <h3 class="text-danger"><?= $pendingTasks ?? 0 ?></h3>
                </div>
            </div>
        </a>
    </div>
    

    <div class="col-md-4">
        <a href="<?= BASE_URL ?>/TaskController/reminders/today" class="text-decoration-none">
            <div class="card border-start border-4 border-warning shadow-sm h-100">
                <div class="card-body">
                    <h6 class="card-title text-muted"><i class="bi bi-calendar-day"></i> Due Today</h6>
                    <h3 class="text-warning"><?= $dueToday ?? 0 ?></h3>
                </div>
            </div>
        </a>
    </div>

    <div class="col-md-4">
        <a href="<?= BASE_URL ?>/TaskController/reminders/week" class="text-decoration-none">
            <div class="card border-start border-4 border-primary shadow-sm h-100">
                <div class="card-body">
                    <h6 class="card-title text-muted"><i class="bi bi-calendar-week"></i> Due This Week</h6>
                    <h3 class="text-primary"><?= $dueThisWeek ?? 0 ?></h3>
                </div>
            </div>
        </a>
    </div>
</div>



<!-- 📇 Contact Cards -->
<div class="row g-4 justify-content-center">
    <div class="col-md-4">
        <div class="card shadow-sm border-0">
            <div class="card-body text-center">
                <h5 class="card-title">📇 Contacts</h5>
                <p class="card-text">View and manage your contacts.</p>
                <a href="<?= BASE_URL ?>/contacts" class="btn btn-outline-primary w-100">Go to Contacts</a>
            </div>
        </div>
    </div>
    <div class="col-md-4">
            <div class="card shadow-sm border-0">
                <div class="card-body text-center">
                    <h5 class="card-title">📋 Manage Leads</h5>
                    <p class="card-text">Add, filter, and manage all leads.</p>
                    <a href="<?= BASE_URL ?>/lead/index" class="btn btn-outline-primary w-100"> View All Leads</a>
                       
                    </a>
                </div>
            </div>
        </div>

    <?php if ($_SESSION['user_role'] === 'admin'): ?>
        <div class="col-md-4">
            <div class="card shadow-sm border-0">
                <div class="card-body text-center">
                    <h5 class="card-title">👥 Assign Contacts</h5>
                    <p class="card-text">Assign or reassign contacts to agents.</p>
                    <a href="<?= BASE_URL ?>/contacts/assign" class="btn btn-outline-success w-100">Assign Contacts</a>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card shadow-sm border-0">
                <div class="card-body text-center">
                    <h5 class="card-title">🔁 Manage Assignments</h5>
                    <p class="card-text">Bulk reassign or unassign contacts.</p>
                    <a href="<?= BASE_URL ?>/contacts/manageAssignments" class="btn btn-outline-warning w-100">Manage</a>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>
