<div class="container mt-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h3><i class="bi bi-person-lines-fill"></i> Leads</h3>
        <?php if (isset($role) && ($role === 'admin' || $role === 'agent')): ?>
        <div>
            
            <a href="<?= BASE_URL ?>/lead/add" class="btn btn-success">
                <i class="bi bi-plus-circle"></i> Add Lead
            </a>
            <?php if ($_SESSION['user_role'] === 'admin'): ?>
            <a href="<?= BASE_URL ?>/lead/import" class="btn btn-success">
                <i class="bi bi-upload"></i> Import Lead
            </a>
            <?php endif; ?>
            <a href="<?= BASE_URL ?>/dashboard/<?= $role ?? 'agent' ?>" class="btn btn-secondary">
                <i class="bi bi-arrow-left"></i> Back to Dashboard
            </a>
        </div>
        <?php endif; ?>
    </div>
    
    <!-- Flash messages -->
    <?php if (!empty($_SESSION['error'])): ?>
        <div class="alert alert-danger"><?= $_SESSION['error']; unset($_SESSION['error']); ?></div>
    <?php endif; ?>

    <?php if (!empty($_SESSION['success'])): ?>
        <div class="alert alert-success"><?= $_SESSION['success']; unset($_SESSION['success']); ?></div>
    <?php endif; ?>

    <!-- Leads table -->
    <?php if (!empty($leads)): ?>
        <div class="table-responsive">
            <table class="table table-hover table-bordered align-middle">
                <thead class="table-light">
                    <tr>
                        <th><i class="bi bi-person"></i> Name</th>
                        <th><i class="bi bi-envelope"></i> Email</th>
                        <th><i class="bi bi-telephone"></i> Phone</th>
                        <th><i class="bi bi-building"></i> Source</th>
                        <th><i class="bi bi-calendar-date"></i> Created Date</th>
                        <th><i class="bi bi-gear"></i> Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($leads as $lead): ?>
                        <tr>
                            <td><?= htmlspecialchars($lead['name']) ?></td>
                            <td><?= htmlspecialchars($lead['email']) ?></td>
                            <td><?= htmlspecialchars($lead['phone']) ?></td>
                            <td><?= htmlspecialchars($lead['source']) ?></td>
                            <td><?= htmlspecialchars($lead['created_at']) ?></td>
                            <td>
                                <a href="<?= BASE_URL ?>/lead/note/<?= $lead['id'] ?>" class="btn btn-sm btn-outline-info" title="Notes">
                                    <i class="bi bi-eye"></i>
                                </a>
                                
                                <a href="<?= BASE_URL ?>/lead/edit/<?= $lead['id'] ?>" class="btn btn-sm btn-outline-warning" title="Edit Lead">
                                    <i class="bi bi-pencil"></i>
                                </a>
                                <a href="<?= BASE_URL ?>/lead/delete/<?= $lead['id'] ?>" class="btn btn-sm btn-outline-danger" title="Delete Lead" onclick="return confirm('Are you sure you want to delete this lead?');">
                                    <i class="bi bi-trash"></i>
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination controls -->
        <?php if (!empty($totalPages) && $totalPages > 1): ?>
            <nav>
                <ul class="pagination justify-content-center">
                    <li class="page-item <?= ($currentPage <= 1) ? 'disabled' : '' ?>">
                        <a class="page-link" href="?page=<?= $currentPage - 1 ?>" tabindex="-1">Previous</a>
                    </li>
                    
                    <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                        <li class="page-item <?= ($i == $currentPage) ? 'active' : '' ?>">
                            <a class="page-link" href="?page=<?= $i ?>"><?= $i ?></a>
                        </li>
                    <?php endfor; ?>
                    
                    <li class="page-item <?= ($currentPage >= $totalPages) ? 'disabled' : '' ?>">
                        <a class="page-link" href="?page=<?= $currentPage + 1 ?>">Next</a>
                    </li>
                </ul>
            </nav>
        <?php endif; ?>

    <?php else: ?>
        <div class="alert alert-info text-center">
            <i class="bi bi-info-circle"></i> No leads found.
        </div>
    <?php endif; ?>
</div>
