<div class="container mt-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h3><i class="bi bi-box-seam"></i> Products</h3>
        <?php if (isset($role) && ($role === 'admin' || $role === 'agent')): ?>
        <div>
            <a href="<?= BASE_URL ?>/product/add" class="btn btn-success">
                <i class="bi bi-plus-circle"></i> Add Product
            </a>
            <a href="<?= BASE_URL ?>/dashboard/<?= $role ?? 'agent' ?>" class="btn btn-secondary">
                <i class="bi bi-arrow-left"></i> Back to Dashboard
            </a>
        </div>
        <?php endif; ?>
    </div>
    
    <!-- Flash messages -->
    <?php if (!empty($_SESSION['error'])): ?>
        <div class="alert alert-danger"><?= $_SESSION['error']; unset($_SESSION['error']); ?></div>
    <?php endif; ?>

    <?php if (!empty($_SESSION['success'])): ?>
        <div class="alert alert-success"><?= $_SESSION['success']; unset($_SESSION['success']); ?></div>
    <?php endif; ?>

    <!-- Products table -->
    <?php if (!empty($products)): ?>
        <div class="table-responsive">
            <table class="table table-hover table-bordered align-middle">
                <thead class="table-light">
                    <tr>
                        <th><i class="bi bi-tag"></i> Name</th>
                        <th><i class="bi bi-card-text"></i> Description</th>
                        <th><i class="bi bi-currency-dollar"></i> Price</th>
                        <th><i class="bi bi-calendar-date"></i> Created Date</th>
                        <th><i class="bi bi-gear"></i> Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($products as $product): ?>
                        <tr>
                            <td><?= htmlspecialchars($product['name']) ?></td>
                            <td><?= htmlspecialchars($product['description']) ?></td>
                            <td>R<?= number_format($product['price'], 2) ?></td>
                            <td><?= htmlspecialchars($product['created_at']) ?></td>
                            <td>
                                <a href="<?= BASE_URL ?>/product/edit/<?= $product['id'] ?>" class="btn btn-sm btn-outline-warning" title="Edit Product">
                                    <i class="bi bi-pencil"></i>
                                </a>
                                <a href="<?= BASE_URL ?>/product/delete/<?= $product['id'] ?>" class="btn btn-sm btn-outline-danger" title="Delete Product" onclick="return confirm('Are you sure you want to delete this product?');">
                                    <i class="bi bi-trash"></i>
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination (optional, if implemented) -->
        <!-- Pagination -->
<?php if (!empty($totalPages) && $totalPages > 1): ?>
    <nav>
        <ul class="pagination justify-content-center">
            <li class="page-item <?= ($currentPage <= 1) ? 'disabled' : '' ?>">
                <a class="page-link" href="?page=<?= $currentPage - 1 ?>" tabindex="-1">Previous</a>
            </li>
            <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                <li class="page-item <?= ($i == $currentPage) ? 'active' : '' ?>">
                    <a class="page-link" href="?page=<?= $i ?>"><?= $i ?></a>
                </li>
            <?php endfor; ?>
            <li class="page-item <?= ($currentPage >= $totalPages) ? 'disabled' : '' ?>">
                <a class="page-link" href="?page=<?= $currentPage + 1 ?>">Next</a>
            </li>
        </ul>
    </nav>
<?php endif; ?>


    <?php else: ?>
        <div class="alert alert-info text-center">
            <i class="bi bi-info-circle"></i> No products found.
        </div>
    <?php endif; ?>
</div>
