<div class="container mt-4">
    <div class="card shadow-sm border-0">
        <div class="card-header bg-info text-white d-flex justify-content-between align-items-center">
            <strong><i class="bi bi-list-check"></i> Tasks / Reminders for <?= htmlspecialchars($contact['name']) ?></strong>
            <button class="btn btn-light btn-sm" data-bs-toggle="collapse" data-bs-target="#taskForm">➕</button>
        </div>

        <!-- Add Task Form -->
        <div class="collapse" id="taskForm">
            <div class="card-body">
                <form action="<?= BASE_URL ?>/TaskController/add/<?= $contact['id'] ?>" method="POST">
                    <div class="mb-3">
                        <label class="form-label">Task Title</label>
                        <input type="text" name="title" class="form-control" required placeholder="Enter task title">
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Due Date</label>
                        <input type="datetime-local" name="due_date" class="form-control" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Status</label>
                        <select name="status" class="form-select">
                            <option value="pending" selected>Pending</option>
                            <option value="completed">Completed</option>
                        </select>
                    </div>

                    <button type="submit" class="btn btn-success">
                        <i class="bi bi-check-circle"></i> Add Task
                    </button>
                </form>
            </div>
        </div>

        <!-- Tasks List -->
        <div class="card-body">
            <?php if (!empty($tasks)): ?>
                <?php foreach ($tasks as $task): ?>
                    <div class="border p-3 mb-3 rounded shadow-sm bg-light">
                        <div class="d-flex justify-content-between align-items-start">
                            <div>
                                <h6 class="mb-1"><?= htmlspecialchars($task['title']) ?></h6>
                                <small class="text-muted">
                                    Due: <?= date('Y-m-d H:i', strtotime($task['due_date'])) ?> |
                                    Status: 
                                    <?php if ($task['status'] === 'completed'): ?>
                                        <span class="badge bg-success">Completed</span>
                                    <?php else: ?>
                                        <span class="badge bg-warning text-dark">Pending</span>
                                    <?php endif; ?>
                                    | By: <?= htmlspecialchars($task['user_name']) ?>
                                </small>
                            </div>
                            <?php if ($_SESSION['user_id'] == $task['user_id']): ?>
                                <div class="d-flex gap-2">
                                    <a href="<?= BASE_URL ?>/TaskController/edit/<?= $task['id'] ?>" class="btn btn-sm btn-outline-primary">
                                        <i class="bi bi-pencil-square"></i>
                                    </a>
                                    <a href="<?= BASE_URL ?>/TaskController/delete/<?= $task['id'] ?>" class="btn btn-sm btn-outline-danger" onclick="return confirm('Delete this task?')">
                                        <i class="bi bi-trash"></i>
                                    </a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div class="alert alert-info">No tasks found for this contact.</div>
            <?php endif; ?>
        </div>
    </div>

    <div class="mt-3">
        <a href="<?= BASE_URL ?>/contacts/" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> Back to Contacts
        </a>
    </div>
</div>
