<div class="container mt-4">
    <div class="card shadow-sm">
        <div class="card-header bg-success text-white">
            <h4 class="mb-0">➕ Add New  User</h4>
        </div>
        <div class="card-body">
            <?php if (!empty($error)): ?>
                <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
            <?php endif; ?>

            <form method="post" action="<?= BASE_URL ?>/users/add">
                <div class="mb-3">
                    <label class="form-label">Name</label>
                    <input type="text" name="name" class="form-control" required>
                </div>

                <div class="mb-3">
                    <label class="form-label">Email</label>
                    <input type="email" name="email" class="form-control" required>
                </div>

                <div class="mb-3">
                    <label for="role" class="form-label">Role</label>
                    <select name="role" id="role" class="form-select" required>
                        <option value="">-- Select Role --</option>
                        <option value="admin">Admin</option>
                        <option value="agent">Agent</option>
                    </select>
                </div>


                 <div class="mb-3">
                    <label class="form-label">Password</label>
                    <input type="password" name="password" id="password" class="form-control" required>
                </div>
                
                <div class="mb-3">
                    <label class="form-label">Confirm Password</label>
                    <input type="password" name="confirm_password" id="confirm_password" class="form-control" required>
                    <div class="invalid-feedback" id="passwordMismatchMsg" style="display: none;">
                        Passwords do not match.
                    </div>
                </div>

                <button type="submit" class="btn btn-primary">Save User</button>
                <a href="<?= BASE_URL ?>/users" class="btn btn-secondary">Cancel</a>
            </form>
        </div>
    </div>
</div>
<script>
document.querySelector("form").addEventListener("submit", function (e) {
    const password = document.getElementById("password");
    const confirm = document.getElementById("confirm_password");
    const message = document.getElementById("passwordMismatchMsg");

    if (password.value !== confirm.value) {
        e.preventDefault(); // Stop form submission
        confirm.classList.add("is-invalid");
        message.style.display = "block";
    } else {
        confirm.classList.remove("is-invalid");
        message.style.display = "none";
    }
});
</script>

