<?php
require_once __DIR__ . '/tcpdf/tcpdf.php';

class TaxInvoicePDF extends TCPDF
{
    public function Header() {
        $imageFile = __DIR__ . '/../public/assets/logo.png';
        $this->Image($imageFile, 15, 10, 35, '', '', '', 'T', false, 300);

        // Company Info
        $this->SetFont('helvetica', 'B', 14);
        $this->SetXY(55, 12);
        $this->Cell(0, 6, 'TechLutry PTY LTD', 0, 1, 'R');

        $this->SetFont('helvetica', '', 10);
        $this->SetX(55);
        $this->Cell(0, 5, '11113 Modisane Street', 0, 1, 'R');
        $this->SetX(55);
        $this->Cell(0, 5, 'Thatch Hill Estate, Olivenhoutbosch', 0, 1, 'R');
        $this->SetX(55);
        $this->Cell(0, 5, 'Midrand, 0187, South Africa', 0, 1, 'R');
        $this->SetX(55);
        $this->Cell(0, 5, 'Phone: +27 79 329 9765', 0, 1, 'R');
        $this->SetX(55);
        $this->Cell(0, 5, 'VAT No: 1234567890', 0, 1, 'R'); // <-- Add VAT number here

        $this->Ln(12);
        $this->SetDrawColor(220, 220, 220);
        $this->Ln(5);
    }

    public function Footer() {
        $this->SetY(-20);
        $this->SetDrawColor(220, 220, 220);
        $this->Line(15, $this->GetY(), $this->getPageWidth() - 15, $this->GetY());

        $this->SetFont('helvetica', 'I', 8);
        $this->Ln(3);
        $this->Cell(0, 6, 'Page ' . $this->getAliasNumPage() . ' of ' . $this->getAliasNbPages(), 0, 1, 'C');

        $this->SetFont('helvetica', 'I', 9);
        $this->Cell(0, 6, 'Thank you for your business!', 0, 0, 'C');
    }

    public function CustomerDetails($customer, $invoice) {
        $this->SetFont('helvetica', 'B', 12);
        $this->Cell(0, 6, 'TAX INVOICE', 0, 1, 'L'); // <-- Changed

        $this->SetFont('helvetica', '', 10);
        $this->Cell(95, 6, 'Invoice #: ' .str_pad($invoice['id'], 5, '0', STR_PAD_LEFT), 0, 0, 'L');
        $this->Cell(85, 6, 'Date: ' . $invoice['invoice_date'], 0, 1, 'R');
        $this->Cell(95, 6, 'Due Date: ' . $invoice['due_date'], 0, 0, 'L');
        $this->Cell(85, 6, 'Status: ' . ucfirst($invoice['status']), 0, 1, 'R');
        $this->Ln(8);

        // Address Blocks
        $this->SetFont('helvetica', 'B', 11);
        $this->Cell(95, 6, 'From:', 0, 0);
        $this->Cell(95, 6, 'Billing To:', 0, 1);

        $this->SetFont('helvetica', '', 10);
        $this->MultiCell(95, 5,
            "TechLutry PTY LTD\n11113 Modisane Street\nThatch Hill Estate, Olivenhoutbosch\nMidrand, 0187, South Africa\nPhone: +27 79 329 9765\nVAT No: 1234567890",
            0, 'L', false, 0
        );
        $this->MultiCell(95, 5,
            $customer['name'] . "\n" . $customer['address_1'] . " " . $customer['address_2'] . 
            "\n" . $customer['city'] . ", " . $customer['country'] . 
            "\nEmail: " . $customer['email'] . 
            "\nPhone: " . $customer['phone'],
            0, 'L', false, 1
        );

        $this->Ln(10);
    }

    public function InvoiceTable($items, $discount = 0, $tax = 0) {
        // Table Header
        $this->SetFillColor(50, 50, 50);
        $this->SetTextColor(255);
        $this->SetDrawColor(180, 180, 180);
        $this->SetLineWidth(0.3);
        $this->SetFont('helvetica', 'B', 10);

        $this->Cell(70, 8, 'Product', 1, 0, 'L', true);
        $this->Cell(20, 8, 'Qty', 1, 0, 'C', true);
        $this->Cell(30, 8, 'Price', 1, 0, 'C', true);
        $this->Cell(30, 8, 'Discount', 1, 0, 'C', true);
        $this->Cell(30, 8, 'Total', 1, 1, 'C', true);

        // Table Body
        $this->SetFont('helvetica', '', 9);
        $this->SetTextColor(0);
        $fill = false;
        $grandTotal = 0;

        foreach ($items as $item) {
            $lineDiscount = $item['discount'] ?? 0;
            $lineTotal = ($item['price'] - $lineDiscount) * $item['quantity'];
            $grandTotal += $lineTotal;

            $this->SetFillColor($fill ? 245 : 255, $fill ? 245 : 255, $fill ? 245 : 255);
            $this->Cell(70, 8, $item['product_name'], 1, 0, 'L', true);
            $this->Cell(20, 8, $item['quantity'], 1, 0, 'C', true);
            $this->Cell(30, 8, 'R ' . number_format($item['price'], 2), 1, 0, 'C', true);
            $this->Cell(30, 8, 'R ' . number_format($lineDiscount, 2), 1, 0, 'C', true);
            $this->Cell(30, 8, 'R ' . number_format($lineTotal, 2), 1, 1, 'C', true);

            $fill = !$fill;
        }

        // Totals Section
        $totalDiscount = floatval($discount);
        $netTotal = $grandTotal - $totalDiscount;
        $taxAmount = ($tax / 100) * $netTotal;
        $totalDue = $netTotal + $taxAmount;

        $this->Ln(2);
        $summaryWidth = 80;
        $summaryX = $this->getPageWidth() - $this->rMargin - $summaryWidth;

        $this->SetFont('helvetica', '', 10);
        $this->SetFillColor(245, 245, 245);

        $this->SetX($summaryX);
        $this->Cell(40, 8, 'Subtotal (Excl. VAT)', 1, 0, 'L', true);
        $this->Cell(40, 8, 'R ' . number_format($netTotal, 2), 1, 1, 'R');

        $this->SetX($summaryX);
        $this->Cell(40, 8, 'VAT ' . $tax . '%', 1, 0, 'L', true);
        $this->Cell(40, 8, 'R ' . number_format($taxAmount, 2), 1, 1, 'R');

        $this->SetFont('helvetica', 'B', 11);
        $this->SetFillColor(50, 50, 50);
        $this->SetTextColor(255);

        $this->SetX($summaryX);
        $this->Cell(40, 10, 'Total (Incl. VAT)', 1, 0, 'L', true);
        $this->Cell(40, 10, 'R ' . number_format($totalDue, 2), 1, 1, 'R', true);

        $this->SetTextColor(0);
    }
}
